#' Azure DevOps Projects
#'
#' @description
#' These functions will allow you to scrape project information from Azure DevOps.
#'
#' @details
#' For more information about project API calls check
#' \url{https://docs.microsoft.com/en-us/rest/api/azure/devops/core/Projects}.
#'
#' @param domain The name of the Azure DevOps organization.
#' @param auth_key Authentication key generated by using \code{\link{vsts_auth_key}}
#' @param quiet logical whether want general running information from printing. Any issue with the API call will
#' still show up if set to \code{TRUE}
#'
#' @rdname vsts_project
#' @export
vsts_get_projects <- function(domain, auth_key, quiet = FALSE) {
  uri <- file.path(AZURE_HOME_URL, domain, "_apis/projects?api-version=6.0")
  response <- httr::GET(uri, httr::add_headers(Authorization = auth_key))

  if (httr::status_code(response) != 200) {
    send_failure_message(response, "get project list")
    return(NULL)
  }

  content <- httr::content(response, encoding = "UTF-8", simplifyDataFrame = TRUE)$value
  if (!quiet) cat("Available projects:", paste(content$name, collapse = ", "), "\n")

  content
}
