% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vue.R
\name{vue}
\alias{vue}
\title{'Vue.js' 'htmlwidget'}
\usage{
vue(
  app = list(),
  width = NULL,
  height = NULL,
  elementId = NULL,
  minified = TRUE
)
}
\arguments{
\item{app}{\code{list} with \code{el} and \code{data} and other pieces
of a 'Vue.js' app}

\item{width, height}{any valid \code{CSS} size unit, but in reality
this will not currently have any impact}

\item{elementId}{\code{character} id of the htmlwidget container
element}

\item{minified}{\code{logical} to indicate minified (\code{minified=TRUE}) or
non-minified (\code{minified=FALSE}) Vue.js}
}
\value{
vue htmlwidget
}
\description{
Use 'Vue.js' with the convenience and flexibility of 'htmlwidgets'.
\code{vue} is a little different from other 'htmlwidgets' though
since it requires specification of the HTML tags/elements separately.
}
\examples{
if(interactive()) {

  library(vueR)
  library(htmltools)

  # recreate Hello Vue! example
  browsable(
    tagList(
      tags$div(id="app", "{{message}}"),
      vue3(
        list(
          el = "#app",
          data = list(
            message = "Hello Vue!"
          )
        )
      )
    )
  )

  # app2 from Vue.js introduction
  browsable(
    tagList(
      tags$div(id="app-2",
        tags$span(
          "v-bind:title" = "message",
          "Hover your mouse over me for a few seconds to see my dynamically bound title!"
        )
      ),
      vue(
        list(
          el = "#app-2",
          data = list(
            message =  htmlwidgets::JS(
              "'You loaded this page on ' + new Date()"
            )
          )
        )
      )
    )
  )

  # app3 from Vue.js introduction
  #  with a setInterval to toggle seen true and false
  browsable(
    tagList(
      tags$div(id="app-3",
        tags$p("v-if"="seen", "Now you see me")
      ),
      htmlwidgets::onRender(
        vue(
          list(
            el = '#app-3',
            data = list(
              seen = TRUE
            )
          )
        ),
        "
  function(el,x){
    var that = this;
    setInterval(function(){that.instance.seen=!that.instance.seen},1000);
  }
        "
      )
    )
  )

}
}
\seealso{
Other htmlwidget: 
\code{\link{vue3}()}
}
\concept{htmlwidget}
