% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{variables}
\alias{variables}
\title{Available Variable Functions}
\usage{
variables(type = NULL, ncols = 5, ...)
}
\arguments{
\item{type}{The output type. Must be either \code{NULL} (returns a
character vector), \code{"matrix"}, or \code{"list"}; or the user may extract
a specific type from a list using:
\code{"character"}, \code{"date"}, \code{"factor"}, \code{"integer"},
\code{"logical"}, \code{"numeric"}, \code{"ordered factor"}.  Setting
\code{type = TRUE} will also return a \code{\link[base]{list}}.
The \code{\link[base]{list}} version breaks the variable functions into
classes.  Specifying a specific class (e.g., \code{type = "numeric"} will
list only variable functions that yield a numeric output.}

\item{ncols}{The number of columns to use if \code{type = "matrix"}.}

\item{\ldots}{Other arguments passed to \code{\link[base]{matrix}}.}
}
\value{
Returns a \code{\link[base]{character}} vector,
\code{\link[base]{matrix}} of all variable functions, or a
\code{\link[base]{list}} of variable functions by type.
}
\description{
See a listing of all available variable functions for use in
\code{\link[wakefield]{r_data_frame}} or \code{\link[wakefield]{r_list}}.
}
\examples{
variables()

variables("list")
variables(TRUE)
names(variables("list"))
variables("ordered factor")
variables("numeric")

variables("matrix")
variables("matrix", ncols=3)
variables("matrix", 1)
variables("matrix", byrow = TRUE)
}
\keyword{type}
