% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gradient.R
\name{gradient}
\alias{gradient}
\title{Computation the gradient of the residuals of an ARMA model}
\usage{
gradient(ar = NULL, ma = NULL, y)
}
\arguments{
\item{ar}{Vector of \code{ar} coefficients.}

\item{ma}{Vector of \code{ma} coefficients.}

\item{y}{Univariate time series.}
}
\value{
A list containing:
\describe{
   \item{\code{der.eps}}{Matrix of the gradient.}
   \item{\code{esp}}{Vector of residuals.}
}
}
\description{
Computes the gradient of the residuals of an ARMA model.
}
\examples{
est<-estimation(p = 1, q = 1, y = CAC40return.sq)
gradient(ar = est$ar, ma = est$ma, y = CAC40return.sq)

}
