% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PortmanteauTest.R
\name{portmanteauTest.h}
\alias{portmanteauTest.h}
\title{Portmanteau tests for one lag.}
\usage{
portmanteauTest.h(ar = NULL, ma = NULL, y, h, grad = NULL)
}
\arguments{
\item{ar}{Vector of AR coefficients. If \code{NULL}, it is a MA process.}

\item{ma}{Vector of MA coefficients. If \code{NULL}, it is an AR process.}

\item{y}{Univariate time series.}

\item{h}{Integer for the chosen lag.}

\item{grad}{Gradient of the series from the function \link{gradient}. If \code{NULL} gradient will be computed.}
}
\value{
A list including statistics and p-value:

\describe{
 \item{\code{Pm.BP}}{Standard portmanteau Box-Pierce statistics.}
 \item{\code{PvalBP}}{p-value corresponding at standard test where the
     asymptotic distribution is approximated by a chi-squared}
 \item{\code{PvalBP.Imhof}}{p-value corresponding at the exact asymptotic distribution
       of the standard portmanteau Box-Pierce statistics.}
 \item{\code{Pm.LB}}{Standard portmanteau Box-Pierce statistics. }
 \item{\code{PvalLB}}{p-value corresponding at standard test where the
     asymptotic distribution is approximated by a chi-squared. }
 \item{\code{PvalLB.Imhof}}{ p-value corresponding at the exact asymptotic distribution
       of the standard portmanteau Ljung-Box statistics.}
 \item{\code{LB.modSN }}{Ljung-Box statistic with the self-normalization method. }
 \item{\code{BP.modSN}}{Box-Pierce statistic with the self-normalization method.} }
}
\description{
Computes Box-Pierce and Ljung-Box statistics for standard, modified and 
self-normalized test procedures.
}
\details{
Portmanteau statistics are generally used to  test the null hypothesis.
 H0 : \eqn{X_t} satisfies an ARMA(p,q) representation.

 The Box-Pierce (BP) and Ljung-Box (LB) statistics, defined as follows, are
 based on the residual empirical autocorrelation. \deqn{Q_{m}^{BP} =
 n\sum_{h}^{m} \rho^{2}(h)} \deqn{Q_{m}^{LB} = n(n+2) \sum_{h}^{m}
 \frac{\rho^{2}(h)}{(n-h)}}

 The standard test procedure consists in rejecting the null hypothesis of an
 ARMA(p,q) model if the statistic \eqn{Q_m > \chi^{2}(1-\alpha)} where
 \eqn{\chi^{2}(1-\alpha)} denotes the \eqn{(1-\alpha)}-quantile of a
 chi-squared distribution with m-(p+q) (where m > p + q) degrees of freedom. The
 two statistics have the same asymptotic distribution, but the LB statistic
 has the reputation of doing better for small or medium sized samples.

 But the significance limits of the residual autocorrelation can be very
 different for an ARMA models with iid noise and ARMA models with only
 uncorrelated noise but dependant. The standard test is obtained under the
 stronger assumption that \eqn{\epsilon_{t}} is iid. So we give an another
 way to obtain the exact asymptotic distribution of the standard portmanteau
 statistics under the weak dependence assumptions.

 Under H0, the statistics \eqn{Q_{m}^{BP}} and \eqn{Q_{m}^{LB}} converge in
 distribution as \eqn{n \rightarrow \infty}, to \deqn{Z_m(\xi_m) :=
 \sum_{i}^{m}\xi_{i,m} Z^{2}_i} where \eqn{\xi_m =
 (\xi_{1,m}',...,\xi_{m,m}')} is the eigenvalues vector of the asymptotic
 covariance matrix of the residual autocorrelations vector and
 \eqn{Z_{1},...,Z_{m}} are independent \eqn{\mathcal{N}(0,1)} variables.
 

 So when the error process is a weak white noise, the asymptotic distribution
 \eqn{Q_{m}^{BP}} and \eqn{Q_{m}^{LB}} statistics is a weighted sum of
 chi-squared. The distribution of the quadratic form \eqn{Z_{m}(\xi_m)} can
 be computed using the algorithm by Imhof available here :
  \code{\link[CompQuadForm]{imhof}}

 We propose an alternative method where we do not estimate an asymptotic
 covariance matrix. It is based on a self-normalization based approach to
 construct a new test-statistic which is asymptotically distribution-free
 under the null hypothesis.

 The sample autocorrelation, at lag \code{h} take the form \eqn{\hat{\rho}(h) =
 \frac{\hat{\Gamma}(h)}{\hat{\Gamma}(0)}}. 
 Where \eqn{\hat{\Gamma}(h) = \frac{1}{n} \sum_{t=h+1}^n \hat{e}_t\hat{e}_{t-h}}.
 With \eqn{\hat{\Gamma}_m = (\hat{\Gamma}(1),...,\hat{\Gamma}(m))   }
 The vector of the first m sample autocorrelations is written \eqn{\hat{\rho}_m = (\hat{\rho}(1),...,\hat{\rho}(m))'}.

 The normalization matrix is defined by \eqn{\hat{C}_{m} =
 \frac{1}{n^{2}}\sum_{t=1}^{n} \hat{S}_t \hat{S}_t'} where \eqn{\hat{S}_t = \sum_{j=1}^{t} (\hat{\Lambda} \hat{U}_{j} -
 \hat{\Gamma}_m)}.

 The sample autocorrelations satisfy \eqn{Q_{m}^{SN}=n\hat{\sigma}^{4}\hat{\rho}_m '
 \hat{C}_m^{-1}\hat{\rho}_m \rightarrow U_{m}}.
 
 \eqn{\tilde{Q}_{m}^{SN} =
 n\hat{\sigma}^{4}\hat{\rho}_{m}' D_{n,m}^{1/2}\hat{C}_{m}^{-1} D_{n,m}^{1/2}\hat{\rho}_{m} \rightarrow U_{m} }
 reprensating respectively the version modified of Box-Pierce (BP) and
 Ljung-Box (LB) statistics. Where \eqn{D_{n,m} = \left(\begin{array}{ccc} \frac{n}{n-1} & & 0 \\
  & \ddots & \\
 0 & & \frac{n}{n-m}
 \end{array}\right)}.
 The critical values for \eqn{U_{m}} have been tabulated by Lobato.
}
\references{
Boubacar Maïnassara, Y. 2011, Multivariate portmanteau test for structural {VARMA} models
with uncorrelated but non-independent error terms \emph{Journal of Statistical Planning and Inference},
vol. 141, no. 8, pp. 2961-2975.

Boubacar Maïnassara, Y. and Saussereau, B. 2018, Diagnostic checking in multivariate {ARMA} models with 
dependent errors using normalized residual autocorrelations ,
 \emph{Journal of the American Statistical Association}, vol. 113, no. 524, pp. 1813-1827.

Francq, C., Roy, R. and Zakoïan, J.M. 2005, Diagnostic Checking in ARMA
 Models with Uncorrelated Errors, \emph{Journal of the American Statistical
 Association}, vol. 100, no. 470 pp. 532-544

Lobato, I.N. 2001, Testing that a dependant process is
 uncorrelated. J. Amer. Statist. Assos. 96, vol. 455, pp. 1066-1076.
}
\seealso{
\code{\link{portmanteauTest}} to obtain the statistics of all m
 lags.
}
