% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wnba_stats_leaders.R
\name{wnba_assistleaders}
\alias{wnba_assistleaders}
\title{\strong{Get WNBA Stats API Assist Leaders}}
\usage{
wnba_assistleaders(
  league_id = "10",
  per_mode = "PerGame",
  player_or_team = "Team",
  season = most_recent_wnba_season() - 1,
  season_type = "Regular Season",
  ...
)
}
\arguments{
\item{league_id}{League - default: '00'. Other options include '10': WWNBA, '20': G-League}

\item{per_mode}{Per Mode - PerGame, Totals}

\item{player_or_team}{Player or Team}

\item{season}{Season - format 2020-21}

\item{season_type}{Season Type - Regular Season, Playoffs, All-Star}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a named list of data frames: AssistLeaders

\strong{AssistLeaders}\tabular{ll}{
   col_name \tab types \cr
   RANK \tab character \cr
   PLAYER_ID \tab character \cr
   PLAYER \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   TEAM_NAME \tab character \cr
   JERSEY_NUM \tab character \cr
   PLAYER_POSITION \tab character \cr
   AST \tab character \cr
}
}
\description{
\strong{Get WNBA Stats API Assist Leaders}

\strong{Get WNBA Stats API Assist Leaders}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ wnba_assistleaders(league_id = '10', player_or_team = "Player")
 wnba_assistleaders(league_id = '10', player_or_team = "Team")
}\if{html}{\out{</div>}}
}
\seealso{
Other WNBA Leaders Functions: 
\code{\link{wnba_alltimeleadersgrids}()},
\code{\link{wnba_assisttracker}()},
\code{\link{wnba_homepagewidget}()},
\code{\link{wnba_leagueleaders}()}
}
\author{
Saiem Gilani
}
\concept{WNBA Leaders Functions}
