% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WGCM.R
\name{wgcm.est}
\alias{wgcm.est}
\title{Weighted Generalised Covariance Measure (WGCM) With Estimated Weight Function
Conditional Independence Test}
\usage{
wgcm.est(X, Y, Z, beta = 0.3, regr.meth, regr.pars = list(), nsim = 499)
}
\arguments{
\item{X}{A (n x d_X) numeric matrix with n observations of d_X variables.}

\item{Y}{A (n x d_Y) numeric matrix with n observations of d_Y variables.}

\item{Z}{A (n x d_Z) numeric matrix with n observations of d_Z variables.}

\item{beta}{A real number between 0 and 1 indicating the fraction of the sample
used to estimate the weight function.}

\item{regr.meth}{One of "gam" and "xgboost" indicating the regression method
used to estimate the conditional expectations E[X|Z] and E[Y|Z] and the
weight function sign(E[(X-E[X|Z])(Y-E[Y|Z])|Z]).}

\item{regr.pars}{Optional additional regression parameters if `regr.meth == "xgboost"`:
can specify `max_nrounds`, `k_cv`, `early_stopping_rounds`, and vectors `eta` and `max_depth`.}

\item{nsim}{Number of samples used to calculate the p-value using simulation.
Only used if max(d_X, d_Y) > 1.}
}
\value{
A p-value for the null hypothesis of conditional independence of X
and Y given Z.
}
\description{
The Weighted Generalised Covariance Measure (WGCM) with Estimated Weight Function
is a test for conditional independence. It is a generalisation of the
Generalised Covariance Measure implemented in the R package
GeneralisedCovarianceMeasure.
}
\examples{
set.seed(1)
n <- 200
Z <- rnorm(n)
X <- Z + 0.3*rnorm(n)
Y1 <- Z + 0.3*rnorm(n)
Y2 <- Z + 0.3*rnorm(n) + 0.3*X
Y3 <- Z + 0.3*rnorm(n) + 0.15*X^2
wgcm.est(X, Y1, Z, beta = 0.3, regr.meth = "gam")
wgcm.est(X, Y2, Z, beta = 0.3, regr.meth = "gam")
wgcm.est(X, Y3, Z, beta = 0.3, regr.meth = "gam")

}
\references{
Please cite the following papers.
Cyrill Scheidegger, Julia Hoerrmann, Peter Buehlmann:
"The Weighted Generalised Covariance Measure"
<http://jmlr.org/papers/v23/21-1328.html>

Rajen D. Shah, Jonas Peters:
"The Hardness of Conditional Independence Testing and the Generalised
Covariance Measure"
<doi:10.1214/19-AOS1857>
}
