% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/km_wlr_calculations_helpers.R
\name{km_quantile_table}
\alias{km_quantile_table}
\title{Table of KM quantiles for two groups}
\usage{
km_quantile_table(
  time_points,
  surv0,
  se0,
  surv1,
  se1,
  arms = c("treat", "control"),
  qprob = 0.5,
  type = c("midpoint", "min"),
  conf_level = 0.95
)
}
\arguments{
\item{time_points}{Vector of time points.}

\item{surv0}{Survival probabilities for group 0.}

\item{se0}{Standard errors for group 0.}

\item{surv1}{Survival probabilities for group 1.}

\item{se1}{Standard errors for group 1.}

\item{arms}{Group labels.}

\item{qprob}{Quantile probability.}

\item{type}{Calculation type.}

\item{conf_level}{Confidence level.}
}
\value{
Data frame of quantiles and CIs for each group.
}
\description{
Returns a data frame of quantiles and confidence intervals for two groups.
}
