% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wine_reviews.R
\name{fetch_wine_reviews}
\alias{fetch_wine_reviews}
\alias{wine_reviews}
\title{Wine prices and points}
\format{
A data frame with 110,203 rows and 8 columns:
\describe{
\item{country}{Country of origin}
\item{state}{State or province of origin}
\item{region}{Region of origin}
\item{winery}{Name of vineyard that made the wine}
\item{variety}{Variety of grape}
\item{points}{Points allocated by WineEnthusiast reviewer on a scale of 0-100}
\item{price}{Price of a bottle of wine in $US}
\item{year}{Year of wine extracted from \code{title}}
}
}
\source{
\url{https://www.kaggle.com/}
}
\usage{
fetch_wine_reviews()
}
\value{
Data frame
}
\description{
A data set containing data on wines from 44 countries, taken from \emph{Wine Enthusiast Magazine}
during the week of 15 June 2017. The data are downloaded and returned.
}
\examples{
\dontrun{
wine_reviews <- fetch_wine_reviews()
wine_reviews |>
  ggplot(aes(x = points, y = price)) +
  geom_jitter(height = 0, width = 0.2, alpha = 0.1) +
  scale_y_log10()
}
}
\references{
Rob J Hyndman (2026) "That's weird: Anomaly detection using R", Section 1.4,
\url{https://OTexts.com/weird/}.
}
