% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_word.R
\name{scrabble}
\alias{anagram}
\alias{scrabble}
\title{Find words that can be constructed from the specified letters}
\usage{
scrabble(allow, model = "*", ban = character(0),
  words = wfindr::words.eng)

anagram(allow, model = "*", ban = character(0), words = wfindr::words.eng)
}
\arguments{
\item{allow}{characters allowed to use to construct words.}

\item{model}{pattern that a word should match. Consists of letters and
unknown characters specifications. Dot \code{.} stands for unknown
character. It may be followed by \code{\{...\}} repetition quantifier (i.e.
\code{.\{n\}}, \code{.\{n,\}}, \code{.\{n,m\}}). Asterisk \code{*} stands
for unknown number of unknown characters. See examples.\cr By default
\code{model} is set to \code{"*"}.}

\item{ban}{characters not allowed to fill gaps in a word.}

\item{words}{vector of words to search within. By default is set to
\code{\link{words.eng}}.}
}
\description{
\code{scrabble} finds words that can be constructed from the
  specified set of letters. \cr \code{anagram} finds words that are
  permutations of the specified set of letters. Usually this set of letters
  is a word itself.
}
\details{
\code{scrabble} and \code{anagram} are functions built on top of the
  \code{\link{find_word}} function with parameter \code{type} set to
  \code{"scrabble"} or \code{"anagram"} respectively and \code{allow}
  parameter moved to the first place to simplify usage (see the first
  example).
}
\examples{
## Find all words that can be constructed of the "thing" word's letters
scrabble("thing")
## same as
find_word(allow = "thing", type = "s")
## take at least 4-letter words
scrabble("thing", ".{4,}")
## same as
find_word(".{4,}", "thing", type = "s")

## Pick 8 random letters and find words that can be constructed of them.
library(magrittr)
sample(letters, 8, TRUE) \%>\% list(letters = ., words = scrabble(.))

## Find anagrams of the word "thing"
anagram("thing")

}
\seealso{
\code{\link{find_word}}
}

