% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{whapi_send_mixed_actions}
\alias{whapi_send_mixed_actions}
\title{Send a WhatsApp interactive message mixing URL/CALL/COPY buttons (Whapi.Cloud)}
\usage{
whapi_send_mixed_actions(
  to,
  body_text,
  buttons,
  header_text = NULL,
  footer_text = NULL,
  token = Sys.getenv("WHAPI_TOKEN", unset = ""),
  timeout = 30,
  verbose = TRUE
)
}
\arguments{
\item{to}{Character(1). Phone in E.164 digits (without "+") or group id.}

\item{body_text}{Character(1). Main body text.}

\item{buttons}{Data frame or list. Up to 3 items; each must define a \code{type}
in \verb{\{'url','call','copy'\}} and include the fields:
\itemize{
\item \code{url}:  \code{title}, \code{id}, \code{url}
\item \code{call}: \code{title}, \code{id}, \code{phone_number}
\item \code{copy}: \code{title}, \code{id}, \code{copy_code}
(\code{id} is auto-generated if missing; \code{title} required)
}}

\item{header_text, footer_text}{Character (optional). Header/footer texts.}

\item{token}{Bearer token. Defaults to env var \code{WHAPI_TOKEN}.}

\item{timeout}{Numeric. Request timeout (seconds). Default 30.}

\item{verbose}{Logical. Print CLI messages? Default TRUE.}
}
\value{
A tibble with fields \code{id}, \code{to}, \code{status}, \code{timestamp}, and the raw response
in \code{resp}.
}
\description{
Sends an interactive \strong{buttons} message that mixes \code{url}, \code{call}, and/or
\code{copy} actions. Input buttons are normalized/validated by
\code{\link[=whapi_coerce_buttons_mixed]{whapi_coerce_buttons_mixed()}} (aliases mapped to \code{title}, auto \code{id} creation,
required fields per type).
}
\examples{
\dontrun{
 Sys.setenv(WHAPI_TOKEN = "your_token_here")
 whapi_send_mixed_actions(
   to = "5581999999999",
   body_text = "Pick an option:",
   buttons = list(
     list(type="url",  title="Website",   url="https://example.com"),
     list(type="call", title="Call us",   phone_number="5581999999999"),
     list(type="copy", title="Copy OTP",  copy_code="123456")
   )
 )
}
}
\seealso{
\code{\link[=whapi_coerce_buttons_mixed]{whapi_coerce_buttons_mixed()}}, \code{\link[=whapi_common_blocks]{whapi_common_blocks()}}, \code{\link[=whapi_perform_request]{whapi_perform_request()}}
}
