% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple_mab_methods.R
\name{plot_mult_estimates}
\alias{plot_mult_estimates}
\title{Plots AIPW Confidence Intervals}
\usage{
plot_mult_estimates(x, cdf, level, ...)
}
\arguments{
\item{x}{A \code{multiple.mab} class object created by \code{\link[=multiple_mab_simulation]{multiple_mab_simulation()}}.}

\item{cdf}{String; specifies the type of CDF to use when analyzing the estimates.
valid CDFs are the 'empirical' CDF, the 'normal' CDF. Used when type = \code{estimate}. The 'normal' CDF uses the fact
that the AIPW estimates are asymptotically normal, while the empirical CDF (eCDF) estimates the CDF from the sample
of AIPW estimates.}

\item{level}{Numeric value of length 1; indicates confidence interval Width (i.e 0.90, 0.95, 0.99).
Defaults to 0.95.}

\item{...}{Arguments to pass to \verb{ggplot2::geom_*} function (e.g. \code{color}, \code{linewidth}, \code{alpha}, \code{bins} etc.). In the case of \code{type = "hist"}, additional
arguments must be passed in to distinct lists, one named \code{geom} which are passed to \verb{ggplot2::geom_*}
and one named \code{facet} which are passed to \code{ggplot2::facet_grid}.}
}
\value{
Minimal ggplot object, that can be customized and added to with \code{+} (to change \code{scales}, \code{labels}, \code{legend}, \code{theme}, etc.).
}
\description{
Plots the uncertainty AIPW estimates for each arm using the specified variance from the repeated trials for \code{\link[=plot.multiple.mab]{plot.multiple.mab()}}.
}
\keyword{internal}
