% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendrogram.R
\name{grid.dendrogram}
\alias{grid.dendrogram}
\title{Draw dendrogram under grid system}
\usage{
grid.dendrogram(
  dend,
  facing = c("bottom", "top", "left", "right"),
  max_height = NULL,
  order = c("normal", "reverse"),
  ...
)
}
\arguments{
\item{dend}{a stats::dendrogram object.}

\item{facing}{facing of the dendrogram.}

\item{max_height}{maximum height of the dendrogram.}

\item{order}{order}

\item{...}{additional options}
}
\value{
view port that plots dendrogram
}
\description{
The dendrogram can be renderred. A viewport is created which contains the dendrogram.
}
\details{
-order should leaves of dendrogram be put in the normal order (1, ..., n) or reverse order (n, ..., 1)?
-... pass to `grid::viewport` which contains the dendrogram.


This function only plots the dendrogram without adding labels. The leaves of the dendrogram
locates at unit(c(0.5, 1.5, ...(n-0.5))/n, "npc").
}
