% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{get_table_rdb}
\alias{get_table_rdb}
\alias{get_table_rdb.when}
\title{Store the table in a relational database}
\usage{
get_table_rdb(td, con, overwrite)

\method{get_table_rdb}{when}(td, con, overwrite = FALSE)
}
\arguments{
\item{td}{A \code{when} object.}

\item{con}{A \code{DBI::DBIConnection} object.}

\item{overwrite}{A boolean, allow overwriting tables in the database.}
}
\value{
Invisible NULL.
}
\description{
Once all the configuration elements have been defined and the dimension table
has been generated, using this function we can obtain it in table format in a
Relational DBMS.
}
\examples{

my_db <- DBI::dbConnect(RSQLite::SQLite())

when() |>
  generate_table() |>
  get_table_rdb(my_db)

DBI::dbDisconnect(my_db)

}
\seealso{
Other getting results: 
\code{\link{get_table_csv}()},
\code{\link{get_table_xlsx}()},
\code{\link{get_table}()}
}
\concept{getting results}
