% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydro_analysis.R
\name{wbt_trace_downslope_flowpaths}
\alias{wbt_trace_downslope_flowpaths}
\title{Trace downslope flowpaths}
\usage{
wbt_trace_downslope_flowpaths(
  seed_pts,
  d8_pntr,
  output,
  esri_pntr = FALSE,
  zero_background = FALSE,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{seed_pts}{Input vector seed points file.}

\item{d8_pntr}{Input D8 pointer raster file.}

\item{output}{Output raster file.}

\item{esri_pntr}{D8 pointer uses the ESRI style scheme.}

\item{zero_background}{Flag indicating whether a background value of zero should be used.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Traces downslope flowpaths from one or more target sites (i.e. seed points).
}
\keyword{HydrologicalAnalysis}
