% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/denpoly.R
\name{denpoly}
\alias{denpoly}
\title{Coefficients of the Denominator Polynomial for \eqn{\tilde{H}_k} and \eqn{\tilde{C}_k}}
\usage{
denpoly(k, alpha = 2)
}
\arguments{
\item{k}{The order of the polynomial (a positive integer)}

\item{alpha}{The type of Wishart distribution \eqn{(\alpha=2/\beta)}:
\itemize{
\item 1/2: Quaternion Wishart
\item 1: Complex Wishart
\item 2: Real Wishart (default)
}}
}
\value{
A vector containing the coefficients of the denominator
polynomial in descending powers of \eqn{\tilde{n}} for the elements of
\eqn{\tilde{H}_k} and \eqn{\mathcal{C}_k}.
}
\description{
This function computes the coefficients of the denominator polynomial for the elements of
\eqn{\tilde{H}_k} and \eqn{\tilde{C}_k}.
The function returns a vector containing the coefficients in descending powers of
\eqn{\tilde{n}}, with the last element being the coefficient of \eqn{\tilde{n}}.
}
\examples{
# Example 1: Compute the denominator polynomial for k = 3, alpha = 2
# Output corresponds to the polynomial n1^5-3n1^4-8n1^3+12n1^2+16n1,
# where n1 is \eqn{\tilde{n}}
denpoly(3)

# Example 2: Compute the denominator polynomial for k = 2, alpha = 1
# Output corresponds to the polynomial n1^3-n1, where n1 is \eqn{\tilde{n}}
denpoly(2, alpha = 1)

}
