% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wmw_pvalue_ties.R
\name{wmw_pvalue_ties}
\alias{wmw_pvalue_ties}
\title{P-value for Wilcoxon-Mann-Whitney Test of No Group Discrimination (With Possible Ties)}
\usage{
wmw_pvalue_ties(x, y, alternative = "two.sided")
}
\arguments{
\item{x}{Numeric vector of cases/group 1 values}

\item{y}{Numeric vector of controls/reference group values}

\item{alternative}{character: "two.sided", "greater", or "less"}
}
\value{
p-value
}
\description{
Tests \eqn{\mathrm{H_0\colon AUC} = 0.5}{AUC = 0.5} vs \eqn{\mathrm{H_1\colon AUC} \neq 0.5}{AUC != 0.5}
with exact finite-sample unbiased variance estimation for arbitrary tie patterns
}
\details{
Implements the Exact finite-sample Unbiased (EU) variance estimator derived from
Hoeffding decomposition theory. Uses tie-corrected kernel \eqn{h(x,y) = \mathbf{1}\{x < y\} + \frac{1}{2}\mathbf{1}\{x = y\}}{h(x,y) = 1{x<y} + 0.5*1{x=y}}
with universal second-order correction factor to provide honest p-values under
\eqn{\mathrm{H_0\colon AUC} = 0.5}{H₀: AUC = 0.5} regardless of tie structure.

Uses three-tier approach: permutation \eqn{(n < 20)}{(n < 20)},
exact unbiased estimator \eqn{(20 \le n < 50)}{(20 <= n < 50)},
asymptotic with corrections \eqn{n \ge 50}{(n >= 50)}.

The unbiased variance estimator is constructed as a specific linear combination:

\eqn{\widetilde{\mathrm{Var}}(\hat{A}) = \frac{n_2\hat{\zeta}_1^2 + n_1\hat{\zeta}_2^2 - \frac{M-1}{M}\hat{v}}{M+1}}

where \eqn{\hat{v}} is the pooled sample variance of kernel values and
\eqn{\hat{\zeta}_1^2, \hat{\zeta}_2^2} are row/column mean variances.

Welch-Satterthwaite degrees of freedom account for bias correction structure:

\eqn{\nu = \frac{(\hat{\sigma}^2)^2}{\frac{(n_2\hat{\zeta}_1^2/(M+1))^2}{n_1-2} + \frac{(n_1\hat{\zeta}_2^2/(M+1))^2}{n_2-2} + \frac{((M-1)\hat{v}/(M(M+1)))^2}{M-3}}}

Function uses mid-rank tie handling throughout, ensuring theoretical consistency
with the corrected null hypothesis framework.

Function assumes \eqn{x} represents cases and \eqn{y} represents the reference level,
in accord with \code{wilcox.test()} and \code{wmw_test()}.
Internal calculations convert to P(X < Y) framework to match theoretical derivations.
}
