% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract-workflow}
\alias{extract-workflow}
\alias{extract_spec_parsnip.workflow}
\alias{extract_recipe.workflow}
\alias{extract_fit_parsnip.workflow}
\alias{extract_fit_engine.workflow}
\alias{extract_mold.workflow}
\alias{extract_preprocessor.workflow}
\alias{extract_postprocessor.workflow}
\alias{extract_tailor.workflow}
\alias{extract_parameter_set_dials.workflow}
\alias{extract_parameter_dials.workflow}
\alias{extract_fit_time.workflow}
\title{Extract elements of a workflow}
\usage{
\method{extract_spec_parsnip}{workflow}(x, ...)

\method{extract_recipe}{workflow}(x, ..., estimated = TRUE)

\method{extract_fit_parsnip}{workflow}(x, ...)

\method{extract_fit_engine}{workflow}(x, ...)

\method{extract_mold}{workflow}(x, ...)

\method{extract_preprocessor}{workflow}(x, ...)

\method{extract_postprocessor}{workflow}(x, ..., estimated = FALSE)

\method{extract_tailor}{workflow}(x, ..., estimated = TRUE)

\method{extract_parameter_set_dials}{workflow}(x, ...)

\method{extract_parameter_dials}{workflow}(x, parameter, ...)

\method{extract_fit_time}{workflow}(x, summarize = TRUE, ...)
}
\arguments{
\item{x}{A workflow}

\item{...}{Not currently used.}

\item{estimated}{A logical for whether the original (unfit) recipe or the
fitted recipe should be returned. This argument should be named.}

\item{parameter}{A single string for the parameter ID.}

\item{summarize}{A logical for whether the elapsed fit time should be returned as a
single row or multiple rows.}
}
\value{
The extracted value from the object, \code{x}, as described in the description
section.
}
\description{
These functions extract various elements from a workflow object. If they do
not exist yet, an error is thrown.
\itemize{
\item \code{extract_preprocessor()} returns the formula, recipe, or variable
expressions used for preprocessing.
\item \code{extract_spec_parsnip()} returns the parsnip model specification.
\item \code{extract_fit_parsnip()} returns the parsnip model fit object.
\item \code{extract_fit_engine()} returns the engine specific fit embedded within
a parsnip model fit. For example, when using \code{\link[parsnip:linear_reg]{parsnip::linear_reg()}}
with the \code{"lm"} engine, this returns the underlying \code{lm} object.
\item \code{extract_mold()} returns the preprocessed "mold" object returned
from \code{\link[hardhat:mold]{hardhat::mold()}}. It contains information about the preprocessing,
including either the prepped recipe, the formula terms object, or
variable selectors.
\item \code{extract_recipe()} returns the recipe. The \code{estimated} argument specifies
whether the fitted or original recipe is returned.
\item \code{extract_parameter_dials()} returns a single dials parameter object.
\item \code{extract_parameter_set_dials()} returns a set of dials parameter objects.
\item \code{extract_fit_time()} returns a tibble with elapsed fit times. The fit
times correspond to the time for the parsnip engine or recipe steps to fit
(or their sum if \code{summarize = TRUE}) and do not include other portions of
the elapsed time in \code{\link[=fit.workflow]{fit.workflow()}}.
\item \code{extract_postprocessor()} returns the postprocessor object.
}
}
\details{
Extracting the underlying engine fit can be helpful for describing the
model (via \code{print()}, \code{summary()}, \code{plot()}, etc.) or for variable
importance/explainers.

However, users should not invoke the \code{predict()} method on an extracted
model. There may be preprocessing operations that \code{workflows} has executed on
the data prior to giving it to the model. Bypassing these can lead to errors
or silently generating incorrect predictions.

\emph{Good}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{workflow_fit |> predict(new_data)
}\if{html}{\out{</div>}}

\emph{Bad}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{workflow_fit |> extract_fit_engine()  |> predict(new_data)
# or
workflow_fit |> extract_fit_parsnip() |> predict(new_data)
}\if{html}{\out{</div>}}
}
\examples{
\dontshow{if (rlang::is_installed("recipes")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(parsnip)
library(recipes)
library(magrittr)

model <- linear_reg() |>
  set_engine("lm")

recipe <- recipe(mpg ~ cyl + disp, mtcars) |>
  step_log(disp)

base_wf <- workflow() |>
  add_model(model)

recipe_wf <- add_recipe(base_wf, recipe)
formula_wf <- add_formula(base_wf, mpg ~ cyl + log(disp))
variable_wf <- add_variables(base_wf, mpg, c(cyl, disp))

fit_recipe_wf <- fit(recipe_wf, mtcars)
fit_formula_wf <- fit(formula_wf, mtcars)

# The preprocessor is a recipe, formula, or a list holding the
# tidyselect expressions identifying the outcomes/predictors
extract_preprocessor(recipe_wf)
extract_preprocessor(formula_wf)
extract_preprocessor(variable_wf)

# The `spec` is the parsnip spec before it has been fit.
# The `fit` is the fitted parsnip model.
extract_spec_parsnip(fit_formula_wf)
extract_fit_parsnip(fit_formula_wf)
extract_fit_engine(fit_formula_wf)

# The mold is returned from `hardhat::mold()`, and contains the
# predictors, outcomes, and information about the preprocessing
# for use on new data at `predict()` time.
extract_mold(fit_recipe_wf)

# A useful shortcut is to extract the fitted recipe from the workflow
extract_recipe(fit_recipe_wf)

# That is identical to
identical(
  extract_mold(fit_recipe_wf)$blueprint$recipe,
  extract_recipe(fit_recipe_wf)
)
\dontshow{\}) # examplesIf}
}
