% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query-wos.R
\name{create_ut_queries}
\alias{create_ut_queries}
\title{Create a vector of UT-based queries}
\usage{
create_ut_queries(uts, uts_per_query = 200)
}
\arguments{
\item{uts}{UTs that will be placed inside the UT-based queries.}

\item{uts_per_query}{Number of UTs to include in each query. Note, there is
a limit on how long your query can be, so you probably want to keep this set
to around 200.}
}
\value{
A vector of queries. You can feed these queries to
\code{\link{pull_wos_apply}} to download data for each query.
}
\description{
Use this function when you have a bunch of UTs whose data you want to pull
and you need to write a series of UT-based queries to do so (i.e., queries
in the form "UT = (WOS:000186387100005 OR WOS:000179260700001)").
}
\examples{
\dontrun{

data <- pull_wos('TS = ("animal welfare") AND PY = (2002-2003)')
queries <- create_ut_queries(data$publication$ut)
pull_wos_apply(queries)
}
}
