% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImputeData.R
\name{ImputeData}
\alias{ImputeData}
\title{Impute Missing Data Using Multiple Imputation}
\usage{
ImputeData(
  data_missing,
  m = 5,
  method = "pmm",
  seed = 123,
  predictorMatrix = NULL
)
}
\arguments{
\item{data_missing}{A data frame containing missing values to be imputed. The function replaces values coded as \code{-999} with \code{NA} before imputation.}

\item{m}{An integer specifying the number of imputed datasets to generate.}

\item{method}{A character string specifying the imputation method. Default is \code{"pmm"} (predictive mean matching).}

\item{seed}{An integer for setting the random seed to ensure reproducibility. Default is \code{123}.}

\item{predictorMatrix}{An optional matrix specifying the predictor structure for the imputation model. Default is \code{NULL}, meaning that the function will use the default predictor matrix created by \code{mice}.}
}
\value{
A list of \code{m} imputed data frames.
}
\description{
The \code{ImputeData} function performs multiple imputation on a data frame with missing values using the \code{mice} package. It handles missing data by creating multiple imputed datasets based on a specified imputation method and returns a list of completed data frames.
}
\details{
This function replaces specified missing value placeholders (e.g., \code{-999}) with \code{NA}, and then applies the multiple imputation by chained equations (MICE) procedure to generate multiple imputed datasets. It supports flexible imputation methods and allows for specifying a custom predictor matrix.
}
\examples{
# Example data with missing values
data <- data.frame(
  M1 = c(rnorm(99), rep(NA, 1)),
  M2 = c(rnorm(99), rep(NA, 1)),
  Y1 = rnorm(100),
  Y2 = rnorm(100)
)
# Perform multiple imputation
imputed_data_list <- ImputeData(data, m = 5)
# Display the first imputed dataset
head(imputed_data_list[[1]])

}
\author{
Wendie Yang, Shufai Cheung
}
