% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCDefWrapper.R
\name{MCDefWrapper}
\alias{MCDefWrapper}
\title{Process Monte Carlo Samples for Defined Parameters in SEM}
\usage{
MCDefWrapper(object, thetahat, thetahatstar_orig)
}
\arguments{
\item{object}{A fitted \code{lavaan} SEM model object.}

\item{thetahat}{A numeric vector of parameter estimates.}

\item{thetahatstar_orig}{A matrix of Monte Carlo samples, where rows represent samples and columns
represent parameters.}
}
\value{
A matrix of computed defined parameters for each Monte Carlo sample.
}
\description{
A wrapper for the internal \code{.MCDef()} function from the \code{semmcci} package.
This function processes Monte Carlo samples to compute defined parameters for structural
equation modeling (SEM).
}
\details{
This function takes Monte Carlo samples of parameter estimates and a fitted SEM model
object to compute the defined parameters (e.g., indirect effects or user-defined contrasts)
based on the model syntax. It is particularly useful for examining derived quantities in SEM
analyses using Monte Carlo methods.
}
\seealso{
\code{\link[=MCMI2]{MCMI2()}}, \code{\link[=RunMCMIAnalysis]{RunMCMIAnalysis()}}
}
\keyword{internal}
