% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{itp_root}
\alias{itp_root}
\title{Find a univariate root of the function f}
\usage{
itp_root(
  f,
  a,
  b,
  k1 = 0.1,
  k2 = 2,
  n0 = 1,
  eps = 0.005,
  maxiter = 100,
  fa = NULL,
  fb = NULL,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{f}{The function to find the root of in terms of its first (one-dimensional) argument}

\item{a}{The lower limit}

\item{b}{The upper limit}

\item{k1}{A tuning parameter}

\item{k2}{Another tuning parameter}

\item{n0}{Another tuning parameter}

\item{eps}{Convergence tolerance}

\item{maxiter}{Maximum number of iterations}

\item{fa}{The value of f(a), if NULL then will be calculated}

\item{fb}{The value of f(b), if NULL then will be calculated}

\item{verbose}{Prints out information during iteration}

\item{...}{Other arguments passed on to f}
}
\value{
A numeric vector of length 1, the root at the last iteration
}
\description{
This finds the value \eqn{x \in [a, b]} such that \eqn{f(x) = 0} using the one-dimensional root finding ITP method (Interpolate Truncate Project). Also see \link[itp]{itp}.
}
\examples{
fpoly <- function(x) x^3 - x - 2 ## example from the ITP_method wikipedia entry
itp_root(fpoly, 1, 2, eps = .0001, verbose = TRUE)

}
\references{
I. F. D. Oliveira and R. H. C. Takahashi. 2020. An Enhancement of the Bisection Method Average Performance Preserving Minmax Optimality. ACM Trans. Math. Softw. 47, 1, Article 5 (March 2021), 24 pages. https://doi.org/10.1145/3423597
}
