% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGpCrossover.R
\name{xegaGpAllCross2Gene}
\alias{xegaGpAllCross2Gene}
\title{Crossover of 2 derivation tree genes.}
\usage{
xegaGpAllCross2Gene(ng1, ng2, lF)
}
\arguments{
\item{ng1}{Derivation tree.}

\item{ng2}{Derivation tree.}

\item{lF}{Local configuration of the genetic algorithm.}
}
\value{
List of 2 derivation trees.
}
\description{
\code{xegaGpAllCross2Gene()} swaps two randomly extracted 
             subtrees between 2 genes. Subtrees must have the same
             root in order to be compatible. The current implementation 
             performs at most \code{lF$MaxTrials()} trials to find compatible
             subtrees. If this fails, the original genes are returned.
}
\details{
Crossover is controlled by one local parameter:
  \itemize{
     \item \code{lF$MaxTrials()}: Maximal number of trials to find 
               compatible subtrees. If compatible subtrees are not 
               found, the gene is returned unchanged.
         }
}
\examples{
gene1<-xegaGpInitGene(lFxegaGpGene)
gene2<-xegaGpInitGene(lFxegaGpGene)
xegaGpDecodeGene(gene1, lFxegaGpGene)
xegaGpDecodeGene(gene2, lFxegaGpGene)
newgenes<-xegaGpAllCross2Gene(gene1, gene2,  lFxegaGpGene)
xegaGpDecodeGene(newgenes[[1]], lFxegaGpGene)
xegaGpDecodeGene(newgenes[[2]], lFxegaGpGene)

}
\seealso{
Other Crossover: 
\code{\link{xegaGpAllCrossGene}()},
\code{\link{xegaGpFilterCross2Gene}()},
\code{\link{xegaGpFilterCrossGene}()}
}
\concept{Crossover}
