% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaPermCrossover.R
\name{xegaPermCrossoverFactory}
\alias{xegaPermCrossoverFactory}
\title{Configure the crossover function of a genetic algorithm.}
\usage{
xegaPermCrossoverFactory(method = "Cross2Gene")
}
\arguments{
\item{method}{A string specifying the crossover function.}
}
\value{
A crossover function for genes.
}
\description{
\code{xegaPermCrossoverFactory} implements the selection
             of one of the crossover functions in this
             package by specifying a text string.
             The selection fails ungracefully (produces
             a runtime error) if the label does not match.
             The functions are specified locally.

             Current support:

             \enumerate{
             \item Crossover functions with two kids:
             \enumerate{
             \item "Cross2Gene" returns \code{xegaPermCross2Gene}.
             }
             \item Crossover functions with one kid:
             \enumerate{
             \item "CrossGene" returns \code{xegaPermCrossGene}.
             }
             }
}
\examples{
XGene<-xegaPermCrossoverFactory("Cross2Gene")
gene1<-xegaPermInitGene(lFxegaPermGene)
gene2<-xegaPermInitGene(lFxegaPermGene)
XGene(gene1, gene2, lFxegaPermGene)
}
\seealso{
Other Configuration: 
\code{\link{lFxegaPermGene}},
\code{\link{xegaPermMutationFactory}()}
}
\concept{Configuration}
