% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectGene.R
\name{Tournament}
\alias{Tournament}
\title{Deterministic tournament of size \code{k}.}
\usage{
Tournament(fit, lF)
}
\arguments{
\item{fit}{Fitness vector.}

\item{lF}{Local configuration.}
}
\value{
The index vector of the best candidates in \code{size} tournaments.
}
\description{
\code{Tournament()} is implemented in two steps:
\enumerate{
\item
A subset of size k of the population is selected with uniform probability.
\item
A gene is selected with probability proportional to fitness.
}
}
\details{
In each generation, the worst \code{k-1} genes 
         in a population do not survive.
}
\examples{
fit<-sample(10, 15, replace=TRUE)
Tournament(fit, NewlFselectGenes()) 
}
