% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xlsx2dfs.R
\name{dfs2xlsx}
\alias{dfs2xlsx}
\title{Write a list of data frames into an excel file with each data frame in a new sheet and the list element name as its sheet name.}
\usage{
dfs2xlsx(dfs, fpath, rowNames = TRUE, colNames = TRUE)
}
\arguments{
\item{dfs}{A list of data frames (names in the list are the names of the sheets).}

\item{fpath}{A character string representing path and filename of the output.}

\item{rowNames}{A boolean indicating whether the first column of a table in every sheet contains row names of the table.}

\item{colNames}{A boolean indicating whether the first line of a table in every sheet contains a header.}
}
\value{
Nothing. Writes out data frames into specified Excel file.
}
\description{
Write a list of data frames into an excel file with each data frame in a new sheet and the list element name as its sheet name.
}
\examples{
df1 <- data.frame(A=c(1, 2), B=c(3, 4))
df2 <- data.frame(C=c(5, 6), D=c(7, 8))
xlsx_fpath <- file.path(tempdir(), "testout.xlsx")
dfs2xlsx(withNames("sheet1", df1, "sheet2", df2), xlsx_fpath)
file.remove(xlsx_fpath)
}
