#' Class linearFilter
#'
#' The class represents the outcome of a linear filter, and is normally
#' generated by the function \code{\link{linear_filter}}
#'
#' @slot y the original label matrix with responses.
#' @slot alpha a numeric vector with the 4 alpha values of the model.
#' @slot pred a matrix with the predictions
#' @slot mean a numeric vector containing the global mean of \code{y}
#' @slot colmeans a numeric vector containing the column means of \code{y}
#' @slot rowmeans a numeric vector containing the row means of \code{y}.
#' @slot na.rm a logical value indicating whether missing values were
#' removed prior to the calculation of the means.
#' @seealso \code{\link{linear_filter}} for creating a linear filter model,
#' and \code{\link[=getters_linearFilter]{getter fuctions for linearFilter}}.
#'
#' @aliases linearFilter
setClass("linearFilter",
         slots = c(
           y = "matrix",
           alpha = "numeric",
           pred = "matrix",
           mean = "numeric",
           colmeans = "numeric",
           rowmeans = "numeric",
           na.rm = "logical"
         ))

validLinearFilter <- function(object){

  if(length(object@mean) != 1)
    return("The mean should be exactly of length 1.")

  if(length(object@colmeans) != ncol(object@y))
    return("The length of colmeans is incompatible with the number of columns in y.")
  if(length(object@rowmeans) != nrow(object@y))
    return("The length of rowmeans is incompatible with the number of rows in y.")

  if(length(object@na.rm) != 1)
    return("na.rm needs to be a single logical value.")

  if(length(object@alpha) != 4)
    return("Alpha should contain exactly 4 numeric values.")
  else
    return(TRUE)
}

setValidity("linearFilter", validLinearFilter)
