% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class_tskrrImputeHeterogeneous.R
\docType{class}
\name{tskrrImputeHeterogeneous-class}
\alias{tskrrImputeHeterogeneous-class}
\alias{tskrrImputeHeterogeneous}
\title{Class tskrrImputeHeterogeneous}
\description{
The class \code{tskrrImputeHeterogeneous} is a subclass of the
class \code{\link[xnet:tskrrHeterogeneous-class]{tskrrHeterogeneous}} and
\code{\link[xnet:tskrrImpute-class]{tskrrImpute}}
specifically for heterogeneous networks with imputed values. It is
the result of the function \code{\link{impute_tskrr}}.
}
\section{Slots}{

\describe{
\item{\code{y}}{the matrix with responses}

\item{\code{k}}{the eigen decomposition of the kernel matrix for the rows}

\item{\code{lambda.k}}{the lambda value used for k}

\item{\code{pred}}{the matrix with the predictions}

\item{\code{g}}{the eigen decomposition of the kernel matrix for the columns}

\item{\code{lambda.g}}{the lambda value used for g}

\item{\code{has.hat}}{a logical value indicating whether the kernel hat matrices
are stored in the object.}

\item{\code{Hk}}{the kernel hat matrix for the rows.}

\item{\code{Hg}}{the kernel hat matrix for the columns.}

\item{\code{labels}}{a list with elements \code{k} and \code{g} (see
\code{\link{tskrr-class}}).
 If any element is \code{NA}, the labels used
are integers indicating the row resp column number.}

\item{\code{imputeid}}{a vector with integer values indicating which of
the values in \code{y} are imputed}

\item{\code{niter}}{an integer value gving the number of iterations used}

\item{\code{tol}}{a numeric value with the tolerance used}
}}

