% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module3_ata_helpers.R
\name{ata_helpers}
\alias{ata_helpers}
\alias{ata_append_constraints}
\alias{ata_form_index}
\alias{ata_obj_coef}
\alias{ata_solve_lpsolve}
\alias{ata_solve_glpk}
\title{Helper functions of ATA}
\usage{
ata_append_constraints(x, mat, dir, rhs)

ata_form_index(x, forms, collapse, internal_index)

ata_obj_coef(x, coef, compensate)

ata_solve_lpsolve(x, time_limit, message, ...)

ata_solve_glpk(x, time_limit, message, ...)
}
\arguments{
\item{mat}{coefficient matrix}

\item{dir}{direction}

\item{rhs}{right-hand-side value}

\item{forms}{indices of forms}

\item{collapse}{\code{TRUE} to collaspe forms into one form}

\item{internal_index}{\code{TRUE} to use internal form indices}

\item{coef}{coefficients}

\item{compensate}{\code{TRUE} to combine coefficients}

\item{time_limit}{the time limit in seconds passed along to solvers}

\item{message}{\code{TRUE} to print messages from solvers}

\item{...}{additional control parameters for solvers}
}
\description{
miscellaneous helper functions of ATA

\code{ata_append_constraints} appends constraint definitions to the model

\code{ata_form_index} converts input forms into actual form indices in the model

\code{ata_obj_coef} processes input coefficients of the objective functions

\code{ata_solve_lpsolve} solves the the MIP model using lp_solve

\code{ata_solve_glpk} solves the the MIP model using GLPK
}
\keyword{internal}
