% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paste.R
\name{wrap}
\alias{wrap}
\alias{dbl_quote}
\alias{sngl_quote}
\alias{bracket}
\alias{brace}
\alias{parens}
\title{Wrap strings}
\usage{
wrap(x, left, right = left)

dbl_quote(..., sep = "")

sngl_quote(..., sep = "")

bracket(..., sep = "")

brace(..., sep = "")

parens(..., sep = "")
}
\arguments{
\item{x}{character to wrap}

\item{left, right}{character pair to wrap with}

\item{sep, ...}{passed to \code{\link[base:paste]{base::paste}} before wrapping}
}
\description{
Wrap strings with flanking characters
}
\examples{
wrap("abc", "__")  #  __abc__
parens("abc")      #   (abc)
sngl_quote("abc")  #   'abc'
dbl_quote("abc")   #   "abc"
bracket("abc")     #   [abc]
brace("abc")       #   {abc}

label <- p("name", parens("attribute"))

label             # "name (attribute)"
unparens(label)   # "name attribute"

# make your own function like this:
# markdown bold
bold <- function(...) wrap(paste(...), "**")
p("make a word", bold("bold"))
# see unbold example in ?unwrap
}
\seealso{
\code{\link{unwrap}} \code{\link{p0}} \code{\link{sentence}}
}
