% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zenpath.R
\name{graph_pairs}
\alias{graph_pairs}
\title{Turn pairs or paths into a graph}
\usage{
graph_pairs(x, var.names = NULL, edgemode = c("undirected", "directed"))
}
\arguments{
\item{x}{\code{\link{matrix}} or \code{\link{list}} of pairs along a zenpath.
Can also be a list containing vectors representing paths in the graph.
Every path must be of length at least 2 (i.e. each vector element of
the list).}

\item{var.names}{names of the variables appearing in \code{x}.}

\item{edgemode}{type of edges to be used: either \code{"undirected"} (the default)
or \code{"directed"} (in which case the order of the nodes in each pair matters).}
}
\value{
a \code{\link[graph:graphNEL-class]{graphNEL}} object; can be displayed using
\code{\link{plot}()} if \pkg{Rgraphviz} is installed.
}
\description{
Pairs are processed to produce a graph with the elements
of the pairs as vertices and the pairs as undirected edges.
The result can be displayed using \code{\link{plot}()} if the
Bioconductor packages \pkg{graph} (for the \code{graphNEL} object)
and optionally \pkg{Rgraphviz} (for plotting) are installed.
}
\note{
This function requires the Bioconductor package \pkg{graph}.
If \pkg{graph} is not installed, an informative error is raised.
Plotting also requires \pkg{Rgraphviz}, but all functionality of
\code{graph_pairs()} is available without it.
}
\examples{
has_Rgraphviz <- requireNamespace("Rgraphviz", quietly = TRUE)
pairs <- matrix(c(1,2, 5,1, 3,4, 2,3, 4,2), ncol = 2, byrow = TRUE)
g <- graph_pairs(pairs)
if (has_Rgraphviz){
  Rgraphviz::plot(g)
}
}
\seealso{
\code{\link{zenplot}()} which provides the zenplot.

Other tools related to constructing zenpaths: 
\code{\link{connect_pairs}()},
\code{\link{extract_pairs}()},
\code{\link{groupData}()},
\code{\link{indexData}()},
\code{\link{zenpath}()}
}
\author{
Marius Hofert and Wayne Oldford
}
\concept{tools related to constructing zenpaths}
