% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot1dloon.R
\name{hist_1d_loon}
\alias{hist_1d_loon}
\title{Histogram in 1d using the interactive loon package}
\usage{
hist_1d_loon(
  zargs,
  breaks = NULL,
  color = NULL,
  fill = NULL,
  showStackedColors = TRUE,
  showBinHandle = FALSE,
  showLabels = FALSE,
  linkingGroup = NULL,
  showScales = FALSE,
  showGuides = FALSE,
  parent = NULL,
  ...
)
}
\arguments{
\item{zargs}{The argument list as passed from \code{\link{zenplot}()}}

\item{breaks}{Argument passed to hist() to get information on bins. Default
is 20 equi-width bins covering the range of x}

\item{color}{colour of the histogram bar interiors, unless fill is specified,
then this is the colour of the border}

\item{fill}{colour of the histogram bar interior if given}

\item{showStackedColors}{Logical determining whether
to show the individual point colours stacked in the histogram}

\item{showBinHandle}{Logical to show a handle to adjust bins}

\item{showLabels}{Logical determining whether axis labels are displayed}

\item{linkingGroup}{A string specifying the initial group of plots to be
linked to this plot}

\item{showScales}{Logical determining whether scales are displayed}

\item{showGuides}{Logical determining whether the background guidelines are
displayed}

\item{parent}{The tk parent for this loon plot widget}

\item{...}{Additional parameters passed to loon::l_hist()}
}
\value{
A loon loon::l_plot(...)
}
\description{
Histogram in 1d using the interactive loon package
}
\seealso{
Other default 1d plot functions using the interactive loon package: 
\code{\link{arrow_1d_loon}()},
\code{\link{boxplot_1d_loon}()},
\code{\link{density_1d_loon}()},
\code{\link{jitter_1d_loon}()},
\code{\link{label_1d_loon}()},
\code{\link{lines_1d_loon}()},
\code{\link{points_1d_loon}()},
\code{\link{rect_1d_loon}()},
\code{\link{rug_1d_loon}()}

Other default 1d plot functions: 
\code{\link{arrow_1d_graphics}()},
\code{\link{arrow_1d_grid}()},
\code{\link{arrow_1d_loon}()},
\code{\link{boxplot_1d_graphics}()},
\code{\link{boxplot_1d_grid}()},
\code{\link{boxplot_1d_loon}()},
\code{\link{density_1d_graphics}()},
\code{\link{density_1d_grid}()},
\code{\link{density_1d_loon}()},
\code{\link{extract_1d}()},
\code{\link{hist_1d_graphics}()},
\code{\link{hist_1d_grid}()},
\code{\link{jitter_1d_graphics}()},
\code{\link{jitter_1d_grid}()},
\code{\link{jitter_1d_loon}()},
\code{\link{label_1d_graphics}()},
\code{\link{label_1d_grid}()},
\code{\link{label_1d_loon}()},
\code{\link{lines_1d_graphics}()},
\code{\link{lines_1d_grid}()},
\code{\link{lines_1d_loon}()},
\code{\link{points_1d_graphics}()},
\code{\link{points_1d_grid}()},
\code{\link{points_1d_loon}()},
\code{\link{rect_1d_graphics}()},
\code{\link{rect_1d_grid}()},
\code{\link{rect_1d_loon}()},
\code{\link{rug_1d_graphics}()},
\code{\link{rug_1d_grid}()},
\code{\link{rug_1d_loon}()}
}
\author{
Marius Hofert and Wayne Oldford
}
\concept{default 1d plot functions}
\concept{default 1d plot functions using the interactive loon package}
