% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zfit_external.R
\name{zlm_robust}
\alias{zlm_robust}
\alias{zpolr}
\alias{zplsr}
\title{Pipe-friendly wrappers for external fitters}
\description{
These functions provide pipe-friendly wrappers around model fitters provided
by several external packages. The functions require the corresponding
packages to be installed, if the required package is missing the functions
warns with directions for how to install it.

\code{zlm_robust()} wraps \code{\link[estimatr:lm_robust]{estimatr::lm_robust()}}, which fits a linear model with
a variety of options for estimating robust standard errors.

\code{zpolr()} wraps \code{\link[MASS:polr]{MASS::polr()}}, which fits an ordered logistic response for
multi-value ordinal variables, using a proportional odds logistic regression.

\code{zplsr()} wraps \code{\link[pls:mvr]{pls::plsr()}}, which performs a partial least squares
regression.
}
\examples{
if (requireNamespace("estimatr") && getRversion() >= "4.1.0")
  zlm_robust(cars, dist ~ speed) |> summary() |> try()

if (requireNamespace("MASS") && getRversion() >= "4.1.0")
  zpolr(mtcars, ordered(gear) ~ mpg + hp) |> summary() |> try()

if (requireNamespace("pls") && getRversion() >= "4.1.0")
  zplsr(cars, dist ~ speed) |> summary() |> try()

}
