## ----setup, include=FALSE-----------------------------------------------------
library(zipcodeR)
real_estate_data <- tibble::tribble(
  ~postal_code,           ~zip_name,
       "34102",        "naples, fl",
       "64105",   "kansas city, mo",
       "33544", "wesley chapel, fl",
       "76550",      "lampasas, tx",
       "85335",     "el mirage, az",
       "61264",         "milan, il",
       "51551",       "malvern, ia",
       "95380",       "turlock, ca",
       "50438",        "garner, ia",
       "62895",    "wayne city, il"
  )
real_estate_data <- dplyr::filter(real_estate_data,nchar(postal_code) == 5)
knitr::opts_chunk$set(echo = TRUE)
set.seed(1000)

## -----------------------------------------------------------------------------
search_state('NY')

## -----------------------------------------------------------------------------
nyzip <- search_state('NY')$zipcode

## -----------------------------------------------------------------------------
states <- c('NY','NJ','CT')

search_state(states)

## -----------------------------------------------------------------------------
search_county('Ocean','NJ')

## -----------------------------------------------------------------------------
search_county("ST BERNARD","LA", similar = TRUE)$zipcode

## -----------------------------------------------------------------------------
head(real_estate_data)

## -----------------------------------------------------------------------------
real_estate_data[1,]

## -----------------------------------------------------------------------------
# Get the ZIP code of the first row of data
zip_code <- real_estate_data[1,]$postal_code

# Pass the ZIP code to the reverse_zipcode() function

reverse_zipcode(zip_code)

## -----------------------------------------------------------------------------
get_tracts(zip_code)

## -----------------------------------------------------------------------------
is_zcta(zip_code)

