% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zoologTaxonomy.R
\docType{data}
\name{zoologTaxonomy}
\alias{zoologTaxonomy}
\title{Taxonomy hierarchy for \pkg{zoolog}}
\format{
The taxonomy is given as a data.frame with columns for
\emph{Species}, \emph{Genus}, \emph{Tribe}, \emph{Subfamily}, and
\emph{Family}.
Each row lists the information for one species:\tabular{lllll}{
   Species \tab Genus \tab Tribe \tab Subfamily \tab Family \cr
   Bos taurus \tab Bos \tab Bovini \tab Bovinae \tab Bovidae \cr
   Bos primigenius \tab Bos \tab Bovini \tab Bovinae \tab Bovidae \cr
   Ovis aries \tab Ovis \tab Caprini \tab Caprinae \tab Bovidae \cr
   Ovis orientalis \tab Ovis \tab Caprini \tab Caprinae \tab Bovidae \cr
   Capra hircus \tab Capra \tab Caprini \tab Caprinae \tab Bovidae \cr
   Capra aegagrus \tab Capra \tab Caprini \tab Caprinae \tab Bovidae \cr
   Gazella gazella \tab Gazella \tab Antilopini \tab Antilopinae \tab Bovidae \cr
   Sus domesticus \tab Sus \tab Suini \tab Suinae \tab Suidae \cr
   Sus scrofa \tab Sus \tab Suini \tab Suinae \tab Suidae \cr
   Cervus elaphus \tab Cervus \tab Cervini \tab Cervinae \tab Cervidae \cr
   Dama mesopotamica \tab Dama \tab Cervini \tab Cervinae \tab Cervidae \cr
   Equus asinus \tab Equus \tab Equini \tab Equinae \tab Equidae \cr
   Equus caballus \tab Equus \tab Equini \tab Equinae \tab Equidae \cr
   Oryctolagus cuniculus \tab Oryctolagus \tab  \tab  \tab Leporidae \cr
   Canis familiaris \tab Canis \tab Canini \tab Caninae \tab Canidae \cr
   Canis lupus \tab Canis \tab Canini \tab Caninae \tab Canidae \cr
}
}
\usage{
zoologTaxonomy
}
\description{
The taxonomy hierarchy for all taxa included in the osteometrical references
of the package \pkg{zoolog}.
This is used to allow the users to group the taxa by any taxonomical category
from \emph{species} to \emph{family}. See
\code{\link{Subtaxonomy}}.
}
\section{File Structure}{

\code{zoologTaxonomy} is an exported variable automatically loaded in
memory. In addition, the csv source file \code{zoologTaxonomy.csv}
generating it is included in the \pkg{zoolog} \code{extdata} folder.
}

\keyword{datasets}
