% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processZoomOutput.R
\name{processZoomOutput}
\alias{processZoomOutput}
\title{Wrapper function to process the raw files from Zoom in a single call}
\usage{
processZoomOutput(
  fileRoot,
  rosetta = TRUE,
  sessionStartDateTime = "1970-01-01 00:00:00",
  recordingStartDateTime = "1970-01-01 00:00:00",
  languageCode = "en"
)
}
\arguments{
\item{fileRoot}{string giving the path to the files and the root}

\item{rosetta}{boolean to produce the rosetta file or not}

\item{sessionStartDateTime}{string giving the start of the session in YYYY-MM-DD HH:MM:SS}

\item{recordingStartDateTime}{string giving the start of the recording in YYYY-MM-DD HH:MM:SS}

\item{languageCode}{string giving the language code}
}
\value{
a named list containing data.frames for each of the available files:
\itemize{
\item meetInfo - A single row with info for the meeting that is in the
participants file. Columns provide information about the meeting from the Zoom
Cloud recording site.
\item partInfo - Each row is a Zoom display name (with display name changes
in parentheses). Columns provide information about participants from the Zoom Cloud
recording site.
\item transcript - Each row is an utterance in the audio transcript. This is the
output from processZoomTranscript.
\item chat - Each row is a message posted to the chat. This is the output
from processZoomChat.
\item rosetta - Each row is a unique display name (within meeting) encountered
in the batchInput. This is used to reconcile user identities.
}
}
\description{
The user provides a fileRoot that is used for a given meeting. Output
files should be named as fileRoot_chat.txt; fileRoot_transcript.vtt;
and fileRoot_participants.csv. Any relevant files will be processed.
}
\examples{
zoomOut = processZoomOutput(fileRoot=file.path(
system.file('extdata', package = 'zoomGroupStats'),"meeting001"
), rosetta=TRUE)
\dontrun{
zoomOut = processZoomOutput(fileRoot="~/zoomMeetings/myMeeting", rosetta=TRUE)
}
}
