% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sample_transcript_sentiment_aws}
\alias{sample_transcript_sentiment_aws}
\title{Parsed spoken language in a 'Zoom' meeting with AWS-based sentiment analysis.}
\format{
A data frame with 30 rows of 17 variables:
\describe{
\item{batchMeetingId}{a character meeting identification variable}
\item{utteranceId}{an incremented numeric identifier for a marked speech utterance}
\item{userName}{'Zoom' display name attached to this speaker}
\item{utteranceStartSeconds}{when the utterance started as the number of seconds from the start of the recording}
\item{utteranceStartTime}{timestamp for the start of the utterance}
\item{utteranceEndSeconds}{when the utterance ended as the number of seconds from the start of the recording}
\item{utteranceEndTime}{timestamp for the end of the utterance}
\item{utteranceTimeWindow}{duration of the utterance, in seconds}
\item{utteranceMessage}{the text of the utterance}
\item{utteranceLanguage}{language code of the utterance}
\item{userEmail}{character email address}
\item{userId}{numeric id of each speaker}
\item{aws_sentClass}{character giving the sentiment classification of this text}
\item{aws_positive}{probability that this text is mixed emotion}
\item{aws_negative}{probability that this text is negative}
\item{aws_neutral}{probability that this text is neutral}
\item{aws_mixed}{probability that this text is positive}
}
}
\source{
\url{http://zoomgroupstats.org/}
}
\usage{
sample_transcript_sentiment_aws
}
\description{
Parsed spoken language in a 'Zoom' meeting with AWS-based sentiment analysis.
}
\keyword{datasets}
