% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aldex-internals.R
\name{aldex.pvals}
\alias{aldex.pvals}
\title{Calculate p-values adjusting for changes in sign as described by Nixon
et al. (2024) in Beyond Normalization: Incorporating Scale Uncertainty
in Microbiome and Gene Expression Analysis (internal only)}
\usage{
aldex.pvals(p.lower, p.upper, p.adjust.method, onesided = FALSE)
}
\arguments{
\item{p.lower}{A P x D x S matrix for P covariates, D taxa/genes, and S
monte carlo samples representing the lower tail p.values}

\item{p.upper}{A P x D x S matrix for P covariates, D taxa/genes, and S
monte carlo samples representing the upper tail p.values}

\item{p.adjust.method}{An adjutment method for p.adjust}

\item{onesided}{(default: FALSE) if sided return p-values for two-sided
test. Otherwise if "lower" or "upper" return one-sided test corresponding
to test that estimate is negative or positive respectively.}
}
\value{
A list with P x D matrices with the non-adjusted and adjusted
p-values.
}
\description{
Calculate p-values adjusting for changes in sign as described by Nixon
et al. (2024) in Beyond Normalization: Incorporating Scale Uncertainty
in Microbiome and Gene Expression Analysis (internal only)
}
\references{
Nixon G, Gloor GB, Silverman JD (2025).
"Incorporating scale uncertainty in microbiome and gene expression analysis as an extension of normalization".
Genome Biology. \doi{10.1186/s13059-025-03609-3}
}
\author{
Justin Silverman, Kyle McGovern
}
