% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/revised_echarts4r_functions.R
\name{e_y_axis_full}
\alias{e_y_axis_full}
\title{Enhanced Y-Axis Setter for echarts4r}
\usage{
e_y_axis_full(
  e,
  index = 0,
  serie = NULL,
  axis = "y",
  yAxis.title = NULL,
  yAxis.position = "bottom",
  yAxis.nameLocation = "center",
  yAxis.axisTick.customValues = NULL,
  yAxis.nameTextStyle.color = NULL,
  yAxis.nameTextStyle.padding = 15,
  yAxis.nameTextStyle.align = NULL,
  yAxis.nameTextStyle.fontStyle = NULL,
  yAxis.nameTextStyle.fontWeight = NULL,
  yAxis.nameTextStyle.fontSize = NULL,
  yAxis.nameTextStyle.fontFamily = NULL,
  yAxis.min = NULL,
  yAxis.max = NULL,
  yAxis.splitNumber = NULL,
  yAxis.axisLabel.rotate = NULL,
  yAxis.axisLabel.margin = NULL,
  yAxis.axisLabel.color = NULL,
  yAxis.axisLabel.fontStyle = NULL,
  yAxis.axisLabel.fontWeight = NULL,
  yAxis.axisLabel.fontFamily = NULL,
  yAxis.axisLabel.fontSize = NULL,
  yAxis.axisLabel.align = NULL,
  yAxis.axisLabel.verticalAlign = NULL,
  yAxis.axisLabel.backgroundColor = NULL,
  yAxis.axisLabel.borderColor = NULL,
  yAxis.axisLabel.borderWidth = NULL,
  yAxis.axisLabel.borderType = NULL,
  yAxis.axisLabel.borderRadius = NULL,
  yAxis.axisLabel.padding = NULL,
  yAxis.axisLabel.shadowColor = NULL,
  yAxis.axisLabel.shadowBlur = NULL,
  yAxis.axisLabel.shadowOffsetX = NULL,
  yAxis.axisLabel.shadowOffsetY = NULL,
  yAxis.axisLabel.textBorderColor = NULL,
  yAxis.axisLabel.textBorderWidth = NULL,
  yAxis.axisLabel.textBorderType = NULL,
  yAxis.axisLabel.textShadowColor = NULL,
  yAxis.axisLabel.textShadowBlur = NULL,
  yAxis.axisLabel.textShadowOffsetX = NULL,
  yAxis.axisLabel.textShadowOffsetY = NULL,
  yAxis.axisLabel.overflow = NULL
)
}
\arguments{
\item{e}{An echarts4r object}

\item{index}{Which y axis to target (zero-based). Default: 0}

\item{serie}{NULL}

\item{axis}{"y"}

\item{yAxis.title}{Axis title}

\item{yAxis.position}{'bottom', 'top'}

\item{yAxis.nameLocation}{'center', 'start', 'middle'}

\item{yAxis.axisTick.customValues}{Custom values for the y-axis}

\item{yAxis.nameTextStyle.color}{hex or named color}

\item{yAxis.nameTextStyle.padding}{numeric}

\item{yAxis.nameTextStyle.align}{'center', 'left', 'right'}

\item{yAxis.nameTextStyle.fontStyle}{'italic', 'normal' 'oblique'}

\item{yAxis.nameTextStyle.fontWeight}{'normal', 'bold', 'bolder', 'lighter'}

\item{yAxis.nameTextStyle.fontSize}{numeric}

\item{yAxis.nameTextStyle.fontFamily}{'sans-serif', 'serif', 'monospace', 'Arial', 'Times New Roman', 'Roboto', 'Open Sans', 'Lato', 'Helvetica', 'Georgia', 'Verdana', 'Arial', 'Tahoma', 'Courier New'}

\item{yAxis.min}{Min value}

\item{yAxis.max}{Max value}

\item{yAxis.splitNumber}{numeric. Increments for numeric axis labels}

\item{yAxis.axisLabel.rotate}{numeric}

\item{yAxis.axisLabel.margin}{numeric}

\item{yAxis.axisLabel.color}{hex or named}

\item{yAxis.axisLabel.fontStyle}{'italic', 'normal' 'oblique'}

\item{yAxis.axisLabel.fontWeight}{'normal', 'bold', 'bolder', 'lighter'}

\item{yAxis.axisLabel.fontFamily}{'sans-serif', 'serif', 'monospace', 'Arial', 'Times New Roman', 'Roboto', 'Open Sans', 'Lato', 'Helvetica', 'Georgia', 'Verdana', 'Arial', 'Tahoma', 'Courier New'}

\item{yAxis.axisLabel.fontSize}{numeric}

\item{yAxis.axisLabel.align}{'center', 'left', 'right'}

\item{yAxis.axisLabel.verticalAlign}{'top', 'bottom'}

\item{yAxis.axisLabel.backgroundColor}{hex or named}

\item{yAxis.axisLabel.borderColor}{hex or named}

\item{yAxis.axisLabel.borderWidth}{numeric}

\item{yAxis.axisLabel.borderType}{'solid', 'dashed', 'dotted'}

\item{yAxis.axisLabel.borderRadius}{numeric}

\item{yAxis.axisLabel.padding}{numeric}

\item{yAxis.axisLabel.shadowColor}{hex or named}

\item{yAxis.axisLabel.shadowBlur}{numeric}

\item{yAxis.axisLabel.shadowOffsetX}{numeric}

\item{yAxis.axisLabel.shadowOffsetY}{numeric}

\item{yAxis.axisLabel.textBorderColor}{hex or named}

\item{yAxis.axisLabel.textBorderWidth}{numeric}

\item{yAxis.axisLabel.textBorderType}{'solid', 'dashed', 'dotted'}

\item{yAxis.axisLabel.textShadowColor}{hex or named}

\item{yAxis.axisLabel.textShadowBlur}{numeric}

\item{yAxis.axisLabel.textShadowOffsetX}{numeric}

\item{yAxis.axisLabel.textShadowOffsetY}{numeric}

\item{yAxis.axisLabel.overflow}{'truncate'}
}
\value{
The modified echarts4r object
}
\description{
Exposes every yAxis.* option so you don't have to hand-craft the JSON.
}
