% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_datasets.R
\docType{data}
\name{renewables2015}
\alias{renewables2015}
\title{Renewable Electricity Output for 186 Countries (2015)}
\format{
A data frame with 186 rows and 9 variables:

\describe{
  \item{\code{country_name}}{country name.}
  \item{\code{adj_sav_edu}}{adjusted savings: education expenditure (percent of GNI).}
  \item{\code{agri_land}}{natural logarithm of total agricultural land area (in sq. km).}
  \item{\code{elec_fossil}}{electricity production from fossil fuels (percent of total).
  Indicates the share of electricity generated from oil, gas, and coal, representing reliance on non-renewable energy.}
  \item{\code{forest_area}}{forest area (percent of land area). Reflects natural resource availability.}
  \item{\code{gov_effec}}{government effectiveness index (range: approximately -2.5 to 2.5). Measures public service quality, policy implementation, and government credibility.}
  \item{\code{pop_density}}{natural logarithm of population density (people per sq. km).}
  \item{\code{access_elec}}{access to electricity (percent of population).}
  \item{\code{renew_elec_output}}{renewable electricity output (in TWh).}
}
}
\source{
\url{https://data.worldbank.org/}
}
\usage{
data(renewables2015)
}
\description{
This dataset provides information on renewable electricity output and a set
of socioeconomic, environmental, and institutional variables for 186 countries
in the year 2015. The data were obtained from the World Bank
(\url{https://data.worldbank.org/}).
}
\details{
The response variable is the renewable electricity output, measured in terawatt-hours (TWh),
representing the total electricity generated from renewable sources such as wind, solar
photovoltaic, solar thermal, hydro, marine, geothermal, solid biofuels, renewable municipal waste,
liquid biofuels, and biogas. Hydro pumped storage is excluded.
}
\examples{
data(renewables2015)
summary(renewables2015)
pairs(renewables2015[, -1], pch = 16, cex = 0.8, col = rgb(0,0,0, 0.5))
}
\keyword{datasets}
