% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BF_users_functions.r
\name{BF10.ttest.TwoSample}
\alias{BF10.ttest.TwoSample}
\title{Bayes Factor for Two-Sample Bayesian t-Test}
\usage{
BF10.ttest.TwoSample(
  tval,
  N1,
  N2,
  prior_analysis,
  location,
  scale,
  dff,
  alternative,
  ROPE = NULL
)
}
\arguments{
\item{tval}{Numeric scalar. Observed t-value from the two-sample t-test.}

\item{N1}{Numeric integer. Sample size of group 1 (must be > 2, will be rounded to nearest integer).}

\item{N2}{Numeric integer. Sample size of group 2 (must be > 2, will be rounded to nearest integer).}

\item{prior_analysis}{Character. Analysis prior under the alternative hypothesis:
\code{"Normal"}, \code{"Moment"} (normal-moment prior), or \code{"t-distribution"}.}

\item{location}{Numeric scalar. Location parameter of the analysis prior.}

\item{scale}{Numeric scalar > 0. Scale parameter of the analysis prior.}

\item{dff}{Numeric scalar. Degrees of freedom for the analysis prior (required if prior_analysis = \code{"t-distribution"}; ignored otherwise).}

\item{alternative}{Character. The direction of the alternative hypothesis two-sided (\code{"two.sided"}), right-sided (\code{"greater"}), or left-sided (\code{"less"}).}

\item{ROPE}{Optional numeric. Bounds for an interval null:
\itemize{
\item For \code{"two.sided"}, must be a numeric vector of length 2 with distinct finite values.
\item For \code{"greater"}, must be a single numeric scalar > 0.
\item For \code{"less"}, must be a single numeric scalar < 0.
}}
}
\value{
A list of class \code{BFvalue_t} containing:
\describe{
\item{type}{Character string describing the test type.}
\item{bf10}{Computed Bayes factor BF10.}
\item{tval}{Observed t-value.}
\item{df}{Degrees of freedom (currently NA / not computed).}
\item{analysis_h1}{List with the analysis prior parameters: \code{prior_analysis}, \code{location}, \code{scale}, and optionally \code{dff}.}
\item{alternative}{Hypothesis tested (\code{"two.sided"}, \code{"greater"}, or \code{"less"}).}
\item{ROPE}{Interval bounds used, if any.}
\item{N1}{Sample size of group 1 .}
\item{N2}{Sample size of group 2 .}
\item{d}{Numeric, observed Cohen's d.}
\item{p.value}{Numeric, p.value.}
}
}
\description{
Compute the Bayes factor (BF10) for a two-sample independent-samples t-test. Supports both point-null and interval-null hypotheses.
}
\examples{
BF10.ttest.TwoSample(
 tval = -1.148,
 N1 = 53,
 N2 = 48,
 prior_analysis = "t-distribution",
 location = 0,
 scale = 0.707,
 dff = 1,
 alternative = "two.sided",
 ROPE = c(-0.36,0.36))

}
