% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3methods.R
\name{predict.modelFits}
\alias{predict.modelFits}
\title{predict.modelFits}
\usage{
\method{predict}{modelFits}(
  object,
  doses = NULL,
  probability_scale = attr(object, "probability_scale"),
  ...
)
}
\arguments{
\item{object}{A modelFits object containing information about the fitted
model coefficients}

\item{doses}{A vector specifying the doses for which a prediction should be
done}

\item{probability_scale}{A boolean variable to specify if the trial has a continuous or a binary outcome. Setting to TRUE will transform predictions from the logit scale to the probability scale, which can be desirable for a binary outcome. Default FALSE.}

\item{...}{Currently without function}
}
\value{
a list with the model predictions for the specified models and doses
}
\description{
This function performs model predictions based on the provided
model and dose specifications
}
\examples{
posterior_list <- list(Ctrl = RBesT::mixnorm(comp1 = c(w = 1, m = 0, s = 1), sigma = 2),
                       DG_1 = RBesT::mixnorm(comp1 = c(w = 1, m = 3, s = 1.2), sigma = 2),
                       DG_2 = RBesT::mixnorm(comp1 = c(w = 1, m = 4, s = 1.5), sigma = 2) ,
                       DG_3 = RBesT::mixnorm(comp1 = c(w = 1, m = 6, s = 1.2), sigma = 2) ,
                       DG_4 = RBesT::mixnorm(comp1 = c(w = 1, m = 6.5, s = 1.1), sigma = 2))
models         <- c("emax", "exponential", "sigEmax", "linear", "betaMod")
dose_levels    <- c(0, 1, 2, 4, 8)
fit            <- getModelFits(models      = models,
                               posterior   = posterior_list,
                               dose_levels = dose_levels)

predict(fit, doses = c(0, 1, 3, 4, 6, 8))

}
