% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{FastDecompositionLap}
\alias{FastDecompositionLap}
\title{Fast eigendecomposition of Laplacian matrix}
\usage{
FastDecompositionLap(
  laplacianMat = NULL,
  k_eigen = 25,
  which = "LM",
  sigma = NULL,
  opts = list(),
  lower = TRUE,
  ...
)
}
\arguments{
\item{laplacianMat}{Laplacian matrix}

\item{k_eigen}{Number of eigenvalues to compute (default: 25)}

\item{which}{Which eigenvalues to compute ("LM", "SM", etc.)}

\item{sigma}{Shift parameter for eigenvalue computation}

\item{opts}{Additional options for eigenvalue computation}

\item{lower}{Whether to compute from lower end of spectrum}

\item{...}{Additional arguments}
}
\value{
List with eigenvalues (evalues) and eigenvectors (evectors)
}
\description{
Perform fast eigendecomposition using RSpectra for large matrices
}
\examples{
\donttest{
# Create a Laplacian matrix and decompose
L <- matrix(c(2, -1, -1, -1, 2, -1, -1, -1, 2), nrow = 3)
decomp <- FastDecompositionLap(L, k_eigen = 2)
}
}
