% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{[[.cbtf}
\alias{[[.cbtf}
\title{Extract the results for a specific test input}
\usage{
\method{[[}{cbtf}(x, i)
}
\arguments{
\item{x}{An object of class \code{cbtf}.}

\item{i}{An index between 1 and the number of test inputs used.}
}
\value{
If the index is valid, a data frame containing the following columns and
attributes:
\item{res}{One of "OK", "FAIL", "WARN" or "SKIP" for each combination of
function and input tested (see the \emph{Value} section in \link{fuzz}).}
\item{msg}{The message received in case of error, warning or skip,
or an empty string if no failure occurred.}
\item{attr(*, "what")}{The character representation of the input tested.}
Otherwise, \code{FALSE}.
}
\description{
Extract the results for a specific test input
}
\examples{
res <- fuzz(funs = c("list", "matrix", "mean"),
            what = test_inputs(c("numeric", "raw")))
res[[6]]

}
