% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dRenewalFrankCopula_user}
\alias{dRenewalFrankCopula_user}
\alias{dRenewalFrankCopula_bi}
\title{Bivariate Count probability Using Frank copula (user)}
\usage{
dRenewalFrankCopula_user(
  x,
  y,
  survX,
  survY,
  distParsX,
  distParsY,
  extrapolParsX,
  extrapolParsY,
  theta,
  time = 1,
  logFlag = FALSE,
  nsteps = 100L,
  extrap = TRUE
)

dRenewalFrankCopula_bi(
  x,
  y,
  distX,
  distY,
  distParsX,
  distParsY,
  theta,
  time = 1,
  logFlag = FALSE,
  nsteps = 100L,
  extrap = TRUE
)
}
\arguments{
\item{x, y}{numeric vector the desired counts.}

\item{survX, survY}{R functions: the survival functions.}

\item{distParsX, distParsY}{List of Lists. Each slot is
a named vector of distribution parameters.}

\item{extrapolParsX, extrapolParsY}{list vec of length 2 values of the
Richardson extrapolation parameters for the inputted distribution.}

\item{theta}{double Frank copula parameter.}

\item{time}{double time at wich to compute the probabilities. Set to 1 by
default.}

\item{logFlag}{TODO}

\item{nsteps}{unsiged integer number of steps used to compute the integral.}

\item{extrap}{logical if \code{TRUE}, Richardson extrapolation will be
applied to improve accuracy.
TODO: (this is for arg. method, maybe!) param dePrilConv logical if \code{TRUE}
      the dePril method will be applied to
compute convolution. Otherwise, the binary decomposition of section 3 will be
used.}

\item{distX, distY}{character name of the survival distribution.}
}
\value{
(log) probability of the bivariate count
\eqn{P(X(t) = x_i, Y(t) = y_i)} where x_i and y_i are the ith component of
the X and Y respectively.

(log) probability of the bivariate count
\eqn{P(X(t) = x_i, Y(t) = y_i)} where x_i and y_i are the ith component of
the X and Y respectively.
}
\description{
Bivariate Count probability Using Frank copula to model dependence
using user passed survival objects

Bivariate Count probability Using Frank copula to model dependence
using built-in distributions
}
\details{
We use Frank copula to model depepndence between 2 renewal count
processes obtained from user passed inter-arrival distribution
defined by \code{survPtr}, \code{distPars} and \code{extrapolPars}.
}
