% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateETrefPM.R
\name{calculateETrefPM}
\alias{calculateETrefPM}
\title{FAO Penman-Monteith method for daily reference evapotranspiration}
\usage{
calculateETrefPM(
  data,
  lat,
  alt,
  za,
  DAP = 1,
  date,
  Ta = NULL,
  Tmin = NULL,
  Tmax = NULL,
  RH = NULL,
  RHmin = NULL,
  RHmax = NULL,
  Rg,
  AP,
  WS,
  G = NULL,
  Kc = NULL
)
}
\arguments{
\item{data}{Data frame containing the data}

\item{lat}{Numeric, latitude in decimal degrees}

\item{alt}{Numeric, altitude in meters}

\item{za}{Numeric, anemometer height in meters}

\item{DAP}{Numeric, days after planting for the first date}

\item{date}{String with the column name containing date records}

\item{Ta}{Optional. String with the column name containing mean air temperature (degC)}

\item{Tmin}{Optional. String with the column name containing minimum air temperature (degC)}

\item{Tmax}{Optional. String with the column name containing maximum air temperature (degC)}

\item{RH}{String with the column name containing mean relative humidity (percent)}

\item{RHmin}{Optional. String with the column name containing minimum relative humidity (percent)}

\item{RHmax}{Optional. String with the column name containing maximum relative humidity (percent)}

\item{Rg}{String with the column name containing global radiation (MJ/m2/day)}

\item{AP}{String with the column name containing atmospheric pressure (hPa)}

\item{WS}{String with the column name containing wind speed (m/s)}

\item{G}{Optional. If NULL, soil heat flux is assumed to be zero (MJ/m2/day)}

\item{Kc}{Optional. Crop coefficient column name}
}
\description{
Calculation of daily reference evapotranspiration using the FAO-56
Penman-Monteith method for a dataset stored in a data.frame.
}
