################################################################################
##                      Wrapper for all gTests methods                        ##
##                                                                            ##
################################################################################
gTests <- function(X1, X2, dist.fun = stats::dist, graph.fun = MST5, 
                   n.perm = 0, dist.args = NULL, graph.args = NULL,
                   maxtype.kappa = 1.14,  seed = NULL) {
  dname <- c(deparse1(substitute(X1)), deparse1(substitute(X2)))
  gTestWrapper(X1, X2, dist.fun, graph.fun, n.perm, dist.args, graph.args, 
               type = "all", seed = seed, maxtype.kappa = maxtype.kappa, 
               dname = dname)
}

gTests_cat <- function(X1, X2, dist.fun = function(x, y) sum(x != y), graph.type = "mstree", 
                       agg.type = "u", K = 5, n.perm = 0, maxtype.kappa = 1.14, seed = NULL) {
  dname <- c(deparse1(substitute(X1)), deparse1(substitute(X2)))
  gTestWrapperCat(X1, X2, dist.fun, agg.type = agg.type, graph.type, K, n.perm, 
                  type = "all", seed = seed, maxtype.kappa = maxtype.kappa, 
                  dname = dname)
}
