% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{cross_validate}
\alias{cross_validate}
\title{Cross-Validate Discovered Equation}
\usage{
cross_validate(
  equation,
  data,
  response = NULL,
  derivative_col = NULL,
  k = 5,
  method = c("block", "random", "rolling"),
  block_size = NULL,
  horizon = 1,
  refit_derivative = FALSE,
  diff_method = "tvr",
  verbose = TRUE
)
}
\arguments{
\item{equation}{Fitted equation object from \code{fit_specified_equation} or
\code{symbolic_search}. Can also be an object of class \code{lm} or \code{nls}.}

\item{data}{Data frame containing all variables.}

\item{response}{Name of the response column (derivative).}

\item{derivative_col}{Alias for response (for compatibility).}

\item{k}{Number of folds for cross-validation.}

\item{method}{CV method: "random", "block", "rolling".}

\item{block_size}{For block methods, size of contiguous blocks.}

\item{horizon}{For rolling CV, forecast horizon.}

\item{refit_derivative}{Logical; whether to recompute derivatives for each fold (currently unused).}

\item{diff_method}{Differentiation method if refitting (currently unused).}

\item{verbose}{Print progress.}
}
\value{
Object of class "cv_result" containing:
\item{rmse}{Root mean squared error per fold}
\item{mae}{Mean absolute error per fold}
\item{r_squared}{R-squared per fold}
\item{mean_rmse}{Average RMSE across folds}
\item{sd_rmse}{Standard deviation of RMSE}
\item{predictions}{List of predicted vs actual per fold}
\item{fold_indices}{Indices used for each fold}
}
\description{
Performs k-fold or block cross-validation to assess out-of-sample predictive
performance of the discovered equation.
}
\examples{
\donttest{
# Toy example using lm
data <- data.frame(
  time = 1:50,
  y = seq(1, 10, length.out = 50) + stats::rnorm(50, sd = 0.1)
)
# Simple linear model as a proxy for a discovered equation
model <- stats::lm(y ~ time, data = data)

# Run cross-validation
cv_res <- cross_validate(
  equation = model,
  data = data,
  response = "y",
  k = 3,
  method = "random"
)
print(cv_res)
}
}
