% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{filter_leading_zeros}
\alias{filter_leading_zeros}
\title{Filter leading zeros from a data set.}
\usage{
filter_leading_zeros(data, obs_column = "confirm", by = NULL)
}
\arguments{
\item{data}{A \verb{<data.frame>} of disease reports (confirm) by date (date).
\code{confirm} must be numeric and \code{date} must be in date format. Optionally,
\code{data} can also have a logical \code{accumulate} column which indicates whether
data should be added to the next data point. This is useful when modelling
e.g. weekly incidence data. See also the \code{\link[=fill_missing]{fill_missing()}} function which
helps add the \code{accumulate} column with the desired properties when dealing
with non-daily data. If any accumulation is done this happens after
truncation as specified by the \code{truncation} argument. If all entries
of \code{confirm} are missing (\code{NA}) the returned estimates will represent the
prior distributions.}

\item{obs_column}{Character (default: "confirm"). If given, only the column
specified here will be used for checking missingness. This is useful if
using a data set that has multiple columns of hwich one of them
corresponds to observations that are to be processed here.}

\item{by}{Character vector. Name(s) of any additional column(s) where
data processing should be done separately for each value in the column.
This is useful when using data representing e.g. multiple geographies. If
NULL (default) no such grouping is done.}
}
\value{
A data.table with leading zeros removed.
}
\description{
Filter leading zeros from a data set.
}
\examples{
cases <- data.frame(
  date = as.Date("2020-01-01") + 0:10,
  confirm = c(0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9)
)
filter_leading_zeros(cases)
}
