% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_strip_plot.R
\name{strip_plot}
\alias{strip_plot}
\title{Strip Plot Design}
\usage{
strip_plot(
  Hplots = NULL,
  Vplots = NULL,
  b = 1,
  l = 1,
  plotNumber = NULL,
  planter = "serpentine",
  locationNames = NULL,
  seed = NULL,
  factorLabels = TRUE,
  randomizeH = TRUE,
  randomizeV = FALSE,
  data = NULL
)
}
\arguments{
\item{Hplots}{Number of horizontal factors, as an integer or a vector.}

\item{Vplots}{Number of vertical factors, as an integer or a vector.}

\item{b}{Number of blocks (full replicates).}

\item{l}{Number of locations. By default \code{l = 1}.}

\item{plotNumber}{Numeric vector with the starting plot number for each location. By default \code{plotNumber = 101}.}

\item{planter}{Option for \code{serpentine} or \code{cartesian} arrangement. By default \code{planter = 'serpentine'}.}

\item{locationNames}{(optional) Names for each location.}

\item{seed}{(optional) Real number that specifies the starting seed to obtain reproducible designs.}

\item{factorLabels}{(optional) If \code{TRUE} retain the levels
labels from the original data set otherwise, numeric labels will be
assigned. Default is \code{factorLabels =TRUE}.}

\item{randomizeH}{Logical flag: \code{TRUE} to randomize horizontal strips separately in each replicate; \code{FALSE} to randomize once per location and reuse.}

\item{randomizeV}{Logical flag: \code{TRUE} to randomize vertical strips separately in each replicate; \code{FALSE} to randomize once per location and reuse.}

\item{data}{(optional) data frame with the labels of vertical and horizontal plots.}
}
\value{
A list with four elements.
\itemize{
  \item \code{infoDesign} is a list with information on the design parameters.
  \item \code{stripsBlockLoc} is a list with the strip blocks for each location.
  \item \code{plotLayouts} is a list with the layout plot numbers for each location.
  \item \code{fieldBook} is a data frame  with the strip plot field book.
}
}
\description{
It randomly generates a strip plot design across locations.
}
\examples{
# Example 1: Generates a strip plot design with 5 vertical strips and 4 horizontal strips,
# with 3 reps in one location.
H <- paste("H", 1:4, sep = "")
V <- paste("V", 1:5, sep = "")
strip1 <- strip_plot(
  Hplots = H,
  Vplots = V,
  b = 3,
  l = 1,
  plotNumber = 101,
  planter = "serpentine",
  locationNames = "A",
  seed = 333
)
strip1$infoDesign
strip1$stripsBlockLoc
strip1$plotLayouts
head(strip1$fieldBook, 12)

# Example 2: Generates a strip plot design with 5 vertical strips and 5 horizontal strips,
# with 6 reps across to 3 locations. In this case, we show how to use the option data.
Hplots <- LETTERS[1:5]
Vplots <- LETTERS[1:4]
strip_data <- data.frame(list(HPLOTS = Hplots, VPLOTS = c(Vplots, NA)))
head(strip_data)
strip2 <- strip_plot(
  Hplots = 5,
  Vplots = 5,
  b = 6,
  l = 3,
  plotNumber = c(101, 1001, 2001),
  planter = "cartesian",
  locationNames = c("A", "B", "C"),
  seed = 222,
  data = strip_data
)
strip2$infoDesign
strip2$stripsBlockLoc
strip2$plotLayouts
head(strip2$fieldBook, 12)

}
\references{
Federer, W. T. (1955). Experimental Design. Theory and Application. New York, USA. The
Macmillan Company.
}
\author{
Didier Murillo [aut],
        Salvador Gezan [aut],
        Ana Heilman [ctb],
        Thomas Walk [ctb],
        Johan Aparicio [ctb],
        Richard Horsley [ctb]
}
